% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcm.R
\name{gcm}
\alias{gcm}
\title{Generalised covariance measure test}
\usage{
gcm(
  Y,
  X,
  Z,
  alternative = c("two.sided", "less", "greater"),
  reg_YonZ = "rf",
  reg_XonZ = "rf",
  args_YonZ = NULL,
  args_XonZ = NULL,
  type = c("quadratic", "max", "scalar"),
  B = 499L,
  coin = FALSE,
  cointrol = list(distribution = "asymptotic"),
  return_fitted_models = FALSE,
  multivariate = c("none", "YonZ", "XonZ", "both"),
  ...
)
}
\arguments{
\item{Y}{Vector or matrix of response values.}

\item{X}{Matrix or data.frame of covariates.}

\item{Z}{Matrix or data.frame of covariates.}

\item{alternative}{A character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or
\code{"less"}. Only applies if \code{type = "quadratic"} and \code{Y} and
\code{X} are one-dimensional.}

\item{reg_YonZ}{Character string or function specifying the regression for
Y on Z. See \code{?\link[comets]{regressions}} for more detail.}

\item{reg_XonZ}{Character string or function specifying the regression for
X on Z. See \code{?\link[comets]{regressions}} for more detail.}

\item{args_YonZ}{A list of named arguments passed to \code{reg_YonZ}.}

\item{args_XonZ}{A list of named arguments passed to \code{reg_XonZ}.}

\item{type}{Type of test statistic, either \code{"quadratic"} (default) or
\code{"max"}. If \code{"max"} is specified, the p-value is computed
based on a bootstrap approximation of the null distribution with
\code{B} samples.}

\item{B}{Number of bootstrap samples. Only applies if \code{type = "max"} is
used.}

\item{coin}{Logical; whether or not to use the \code{coin} package for
computing the test statistic and p-value. The \code{coin} package
computes variances with n - 1 degrees of freedom.
The default is \code{TRUE}.}

\item{cointrol}{List; further arguments passed to
\code{\link[coin]{independence_test}}.}

\item{return_fitted_models}{Logical; whether to return the fitted regressions
(default is \code{FALSE}).}

\item{multivariate}{Character; specifying which regression can handle
multivariate outcomes (\code{"none"}, \code{"YonZ"}, \code{"XonZ"}, or
\code{"both"}). If \code{"none"}, then the regression is run using each
column in Y (or X) as the response.}

\item{...}{Additional arguments passed to \code{reg_YonZ}.}
}
\value{
Object of class '\code{gcm}' and '\code{htest}' with the following
components:
\item{\code{statistic}}{The value of the test statistic.}
\item{\code{p.value}}{The p-value for the \code{hypothesis}}
\item{\code{parameter}}{In case X is multidimensional, this is the degrees of
    freedom used for the chi-squared test.}
\item{\code{hypothesis}}{String specifying the null hypothesis.}
\item{\code{null.value}}{String specifying the null hypothesis.}
\item{\code{method}}{The string \code{"Generalised covariance measure test"}.}
\item{\code{data.name}}{A character string giving the name(s) of the data.}
\item{\code{rY}}{Residuals for the Y on Z regression.}
\item{\code{rX}}{Residuals for the X on Z regression.}
\item{\code{models}}{List of fitted regressions if \code{return_fitted_models} is \code{TRUE}.}
}
\description{
Generalised covariance measure test
}
\details{
The generalised covariance measure test tests whether the conditional
covariance of Y and X given Z is zero.
}
\examples{
n <- 1e2
X <- matrix(rnorm(2 * n), ncol = 2)
colnames(X) <- c("X1", "X2")
Z <- matrix(rnorm(2 * n), ncol = 2)
colnames(Z) <- c("Z1", "Z2")
Y <- X[, 2]^2 + Z[, 2] + rnorm(n)
(gcm1 <- gcm(Y, X, Z))

}
\references{
Rajen D. Shah, Jonas Peters "The hardness of conditional independence testing
and the generalised covariance measure," The Annals of Statistics, 48(3),
1514-1538. \doi{10.1214/19-aos1857}
}
