% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc2Node.r
\name{calc2Node}
\alias{calc2Node}
\alias{2Node}
\alias{2node}
\title{Comfort Indices based on the 2-Node-Model}
\usage{
calc2Node(ta, tr, vel, rh, clo = 0.5, met = 1, wme = 0, pb = 760, ltime = 60,
ht = 171, wt = 70, tu = 40, obj = "set", csw = 170, cdil = 120, cstr = 0.5,
varOut = "else")
}
\arguments{
\item{ta}{a numeric value presenting air temperature in [degree C]}

\item{tr}{a numeric value presenting mean radiant temperature in [degree C]}

\item{vel}{a numeric value presenting air velocity in [m/s]}

\item{rh}{a numeric value presenting relative humidity [\%]}

\item{clo}{a numeric value presenting clothing insulation level in [clo]}

\item{met}{a numeric value presenting metabolic rate in [met]}

\item{wme}{a numeric value presenting external work in [met]}

\item{pb}{a numeric value presenting barometric pressure in [torr] or [mmHg]}

\item{ltime}{a numeric value presenting exposure time in [minutes]}

\item{ht}{a numeric value presenting body height in [cm]}

\item{wt}{a numeric value presenting body weight in [kg]}

\item{tu}{a numeric value presenting turbulence intensity in [\%]}

\item{obj}{a character element, either "set" or "pmvadj"}

\item{csw}{a numeric value presenting the driving coefficient for regulatory sweating}

\item{cdil}{a numeric value presenting the driving coefficient for vasodilation}

\item{cstr}{a numeric value presenting the driving coefficient for vasoconstriction}

\item{varOut}{a string value either "else" for normal output of SET or "skinWet" to report value of skin wettedness}
}
\value{
returns a data.frame with the following items:
\describe{
\item{\code{et - }Effective temperature}{}
\item{\code{tsens - }Predicted thermal sensation}{}
\item{\code{disc - }Predicted discomfort}{}
\item{\code{ps - }Predicted percentage satisfied with the level of air movement}{}
\item{\code{pd - }Predicted percentage dissatisfied due to draft}{}
\item{\code{pts - }Predicted thermal sensation vote based on set}{}
\item{\code{pmvg - }Gagge's version of Fanger's PMV}{}
\item{\code{pmvstar - }Same as Fanger's PMV except that dry is calculated 
using SET* rather than the operative temperature}{}
}
The other functions return a single index, e.g. code(calcSET) returns the 
standard effective temperature.
}
\description{
\code{calc2Node} calculates Comfort Indices based on the 2-Node-Model by Gagge et al.
}
\details{
All variables must have the same length 1. For the calculation of several 
values use function \code{calcComfInd}. The value of \code{obj} defines 
whether the function will use the version presented in ASHRAE 55-2013 for 
adjustment of pmv (obj = "pmvadj"), or the original code by Gagge to calculate 
set (obj = "set"). In the version presented in ASHRAE 55-2013, the lines of 
code related to self-generated convection is deleted. Therefore, a difference 
can only be seen at higher values of met.
}
\note{
In case one of the variables is not given, a standard value will be taken 
from a list (see \code{\link{createCond}} for details.
}
\examples{
## Calculation of a single set of values.
calc2Node(22, 25, .50, 50)
}
\references{
ASHRAE Standard 55-2013. Thermal environmental conditions for human occupancy. 
American society of heating, Refrigerating and Air-Conditioning Engineering, 
Atlanta, USA, 2013.

Fountain & Huizenga (1995) A thermal sensation model for use by the 
engineering profession ASHRAE RP-781 Final report.

Gagge, Fobelets & Berglund (1986) A standard predictive index 
of human response to the thermal environment, ASHRAE transactions, 92 (2B), 709-731.
}
\seealso{
see also \code{\link{calcComfInd}}
}
\author{
The code for \code{calc2Node} is based on the code in BASIC and C++ presented 
by Fountain and Huizenga (1995). The translation into R-language and comparison 
with ASHRAE 55-2013 conducted by Marcel Schweiker.
}
