% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcHbExSteady.r
\name{calcHbExSteady}
\alias{calcHbExSteady}
\alias{Hbexsteady}
\alias{HbExSteady}
\alias{HbEx}
\title{Human Body Exergy Consumption Rate Using Steady State Method}
\usage{
calcHbExSteady(ta, tr, rh, vel, clo, met, tao, rho, frad = 0.7, eps = 0.95, 
ic = 1.085, ht = 171, wt = 70, tcr = 37, tsk = 36, basMet = 58.2, warmUp = 60, 
cdil = 100, sigmatr = 0.25)
}
\arguments{
\item{ta}{a numeric value presenting air temperature in [degree C]}

\item{tr}{a numeric value presenting mean radiant temperature in [degree C]}

\item{rh}{a numeric value presenting relative humidity [\%]}

\item{vel}{a numeric value presenting air velocity in [m/s]}

\item{clo}{a numeric value presenting clothing insulation level in [clo]}

\item{met}{a numeric value presenting metabolic rate in [met]}

\item{tao}{a numeric value presenting outdoor air temperature in [degree C]}

\item{rho}{a numeric value presenting outdoor relative humidity [\%]}

\item{frad}{a numeric value presenting the fraction of body exposed to 
radiation 0.7(for seating), 0.73(for standing) [-]}

\item{eps}{a numeric value presenting emissivity [-]}

\item{ic}{a numeric value presenting permeability of clothing: 1.084 
(average permeability), 0.4 (low permeability)}

\item{ht}{a numeric value presenting body height in [cm]}

\item{wt}{a numeric value presenting body weight in [kg]}

\item{tcr}{a numeric value presenting initial value for core temperature in [degree C]}

\item{tsk}{a numeric value presenting initial value for skin temperature in [degree C]}

\item{basMet}{a numeric value presenting basal metabolic rate in [met]}

\item{warmUp}{a numeric value presenting length of warm up period, i.e. number 
of times, loop is running for HBx calculation}

\item{cdil}{a numeric value presenting value for cdil in 2-node model of Gagge}

\item{sigmatr}{a numeric value presenting value for cdil in 2-node model of Gagge}
}
\value{
Returns a data.frame with the following columns \cr{
\cr
Exergy input\cr
\code{xInmets} Exergy input through metabolism [W/m2]\cr
\code{xInmetwcs} Label warm/ cold for exergy input through metabolism [W/m2]\cr
\code{xInAIRwcs} Exergy input through inhaled humid air [W/m2]\cr
\code{xInAIRwcwcs} Label warm/ cold for exergy input through inhaled humid air [W/m2]\cr
\code{xInAIRwds} Exergy input through inhaled dry air [W/m2]\cr
\code{xInAIRwdwds} Label wet/ dry for exergy input through inhaled dry air [W/m2]\cr
\code{xInLUNGwcs} Exergy input through water lung [W/m2]\cr
\code{xInLUNGwcwcs} Label warm/ cold for exergy input through water lung [W/m2]\cr
\code{xInLUNGwds} Exergy input through water lung [W/m2]\cr
\code{xInLUNGwdwds} Label wet/ dry for exergy input through water lung [W/m2]\cr
\code{xInsheLLwcs} Exergy input through water from sweat [W/m2]\cr
\code{xInsheLLwcwcs} Label warm/ cold for exergy input through water from sweat [W/m2]\cr
\code{xInsheLLwds} Exergy input through water from sweat [W/m2]\cr
\code{xInsheLLwdwds} Label wet/ dry for exergy input through water from sweat [W/m2]\cr
\code{xInraDs} Exergy input through radiation [W/m2]\cr
\code{xInraDwcs} Label warm/ cold for exergy input through radiation [W/m2]\cr
\code{xIntotaLs} total exergy input [W/m2]\cr
\cr
Exergy output\cr
\code{xoutstorecores} Exergy stored in core [W/m2]\cr
\code{xoutstoreshels} Exergy stored in shell [W/m2]\cr
\code{xoutaIRwcs} Exergy output through exhaled humid air [W/m2]\cr
\code{xoutaIRwcwcs} Label warm/ cold for exergy output through exhaled humid air [W/m2]\cr
\code{xoutaIRwds} Exergy output through exhaled dry air [W/m2]\cr
\code{xoutaIRwdwds} Label wet/ dry for exergy output through exhaled dry air [W/m2]\cr
\code{xoutswEATwcs} Exergy output through water vapour from sweat [W/m2]\cr
\code{xoutswEATwcwcs} Label warm/ cold for exergy output through water vapour from sweat [W/m2]\cr
\code{xoutswEATwds} Exergy output through water vapour from sweat [W/m2]\cr
\code{xoutswEATwdwds} Label wet/ dry for exergy output through water vapour from sweat [W/m2]\cr
\code{xoutraDs} Exergy output through radiation [W/m2]\cr
\code{xoutraDwcs} Label warm/ cold for exergy output through radiation [W/m2]\cr
\code{xoutCONVs} Exergy output through convection [W/m2]\cr
\code{xoutCONVwcs} Label warm/ cold for exergy output through convection [W/m2]\cr
\code{xouttotaLs} total exergy output [W/m2]\cr
\cr
Exergy balance\cr
\code{xconss} total exergy consumption [W/m2]\cr
\code{xConsumption} total exergy consumption [W/m2]\cr
\cr
Additional values\cr
\code{tsks} Calculated skin temperature [degree C]\cr
\code{tcrs} Calculated core temperature [degree C]\cr
\code{ws} Calculated skin wettedness [degree C]\cr
}
}
\description{
\code{calcHbExSteady} calculates the human body exergy 
consumption rate  in W/m2 using steady state method based on a set of 
environmental variables.
}
\note{
According to Gagge's paper (1973), the value of 'cdil' may vary between 75 
and 225 and 'sigma-tr' between 0.25 and 0.75. There is a note in the appendix 
of his paper saying two things: 1) whatever the values taken for cdil and 
sigma-tr, there must be no significant change in resulting thermal equilibrium. 
But, the values taken for cdil and sigmaTr do affect time to equilibrium. 
According to the analysis of Schweiker et al. (2016), the values of 100 and 
.25 lead to the best fit of calculated and observed skin temperature.
}
\examples{
## Calculation of human body exergy consumption rate 
calcHbExSteady(22, 24, 50, .1, .8, 1.2, 5, 80)

## Calculation of multiple values
dfData <- data.frame(ta=c(20:25), tr=c(20:25))
dfResult <- calcHbExSteady(22, 24, 50, .1, .8, 1.2, 5, 80) 
for(i in 1:nrow(dfData)){
dfResult[i,] <- calcHbExSteady(dfData$ta[i], dfData$tr[i], 50, .1, .5, 1.1, 5, 80)
}
}
\references{
Schweiker, Kolarik, Dovjak & Shukuya (2016) <doi:10.1016/j.enbuild.2016.01.002>

Shukuya (2015) Calculation of human body-core and skin-layer temperatures under 
unsteady-state conditions-for unsteady-state human-body exergy analysis-, 
internal report of exergy-research group, Tech. rep.
}
\seealso{
see also \code{\link{calcComfInd}}, \code{\link{calcHbExUnsteady}}
}
\author{
This function is based on a VBA code developed by Masanori Shukuya. 
transformation of VBA-code and Excel procedures into R syntax by Marcel 
Schweiker.
}
