% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centileplot.R
\name{centileplot}
\alias{centileplot}
\title{Centiles Plot from a PGS Association}
\usage{
centileplot(
  df = NULL,
  prs_col = "SCORESUM",
  phenotype_col = "Phenotype",
  decile = FALSE,
  continuous_metric = NA
)
}
\arguments{
\item{df}{a dataframe with individuals on each row, and at least the following
columns:
\itemize{
\item one ID column,
\item one PGS column, with numerical continuous values following a normal distribution,
\item one Phenotype column, can be numeric (Continuous Phenotype), character, boolean or factors (Discrete Phenotype)
}}

\item{prs_col}{a character specifying the PGS column name}

\item{phenotype_col}{a character specifying the Phenotype column name}

\item{decile}{a boolean specifying if centiles or deciles should be used}

\item{continuous_metric}{a facultative character specifying what metric to
use for continuous Phenotype, only three options: \code{NA}, \code{"median"} or \code{"mean"}}
}
\value{
return a figure of results in the format ggplot2 object
}
\description{
\code{centileplot()} take a distribution of PGS, a Phenotype and eventual Confounders
return a plot (ggplot2 object) with centiles (or deciles if not enough individuals)
of PGS in x and Prevalence/Median/Mean of the Phenotype in y
}
