% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctests.R
\name{kdeDirichlet}
\alias{kdeDirichlet}
\title{Density estimation on the simplex with Dirichlet kernel}
\usage{
kdeDirichlet(x, adj = 1, n = 200, kdegrid = NULL, delta = FALSE)
}
\arguments{
\item{x}{data set of (complete) compositional data, i.e. data summing to 1 by columns}

\item{adj}{accessory scaling factor, for modifying the bandwith in analogy to 
function [MASS::kde()]}

\item{n}{integer, number of grid nodes on each component, where to estimate 
the density; ignored if `kdegrid` is given}

\item{kdegrid}{data frame, set of locations where to estimate the density; either
specify `n` or `kdegrid`}

\item{delta}{logical or real controlling if/how zeroes in `x` are treated; logical 
works only for `kdegrid=NULL` and uses correction by half the grid cell size, 
otherwise give a real value; this value will be added to the whole composition, including
the non-zero values.}
}
\value{
A list of two or three elements, depending on the value
of `kdegrid`. If `kdegrid` is null, the function is assumed to be used for 
two-dimensional plotting, and the output is one compatible with the function
[image()], i.e. a list of three elements (vector of x-values, vector of y-values
and matrix of density values computed). If `kdegrid` is a grid, then the
output has two elements: the input grid and a vector of computed densities.

 NOTE: no effort is made to check that `kdegrid` has the right class, dimension
 or content.
 }
 
\references{
 Aitchison J., Lauder I.J. (1985) Kernel density estimation for compositional data;
 _J. Roy. Statist. Soc. Ser. C_, 34 (2): 129-137.
 
 Ouimet, F. and Tolosana-Delgado, R. (2022) Asymptotic properties of Dirichlet kernel 
 density estimators; _Journal of Multivariate Analysis_ 187: 104832, 
 \doi{10.1016/j.jmva.2021.104832}
}
\description{
Function to compute the kernel density estimation on a grid of the simplex
}
\details{
This function computes the kde (kernel density estimation) of the probability
density function of a random composition on the simplex, by using Dirichlet 
kernels. The method was proposed by Aitchison and Lauder (1985).
}
