% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian.tolerance.R
\name{Gaussian.tolerance}
\alias{Gaussian.tolerance}
\title{Bell-shaped tolerance function}
\usage{
Gaussian.tolerance(trait.values, env, sigma.a = 0.001, ...)
}
\arguments{
\item{trait.values}{Values of trait related to habitat preference}

\item{env}{Vector of environmental conditions in the local communities}

\item{sigma.a}{Tolerance width (same for all species)}

\item{...}{Any additional parameters}
}
\value{
A matrix of survival probabilities, communities in rows, species/individuals in columns
}
\description{
It calculates probability of seedling's survival from their trait related to habitat filtering and the local environment.
}
\details{
It assumes that probability of seedling's survival is maximal if the local
environment has the same value as its trait. Survival probability decrease as
environmental value departs from the optimum according to a Gaussian (bell-shaped)
curve. The speed of decrease depends on the tolerance width parameter (\code{sigma.a}).
}
\seealso{
\code{\link{tolerance}}
}
