% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_meta.R
\name{curve_meta}
\alias{curve_meta}
\title{Consonance Functions For Meta-Analytic Data}
\usage{
curve_meta(x, measure = "default", method = "uni", robust = FALSE,
  cluster = NULL, adjust = FALSE, steps = 1000, table = TRUE)
}
\arguments{
\item{x}{Object where the meta-analysis parameters are stored, typically a
list produced by 'metafor'}

\item{measure}{Indicates whether the object has a log transformation or is normal/default.
The default setting is "default. If the measure is set to "ratio", it will take
logarithmically transformed values and convert them back to normal values in the dataframe.
This is typically a setting used for binary outcomes such as risk ratios,
hazard ratios, and odds ratios.}

\item{method}{Indicates which meta-analysis metafor function is being used.
Currently supports rma.uni ("uni"), which is the default, rma.mh ("mh"),
and rma.peto ("peto")}

\item{robust}{a logical indicating whether to produce cluster robust interval estimates
Default is FALSE.}

\item{cluster}{a vector specifying a clustering variable to use for
constructing the sandwich estimator of the variance-covariance matrix.
Default setting is NULL.}

\item{adjust}{logical indicating whether a small-sample correction should
be applied to the variance-covariance matrix. Default is FALSE.}

\item{steps}{Indicates how many consonance intervals are to be calculated at
various levels. For example, setting this to 100 will produce 100 consonance
intervals from 0 to 100. Setting this to 10000 will produce more consonance
levels. By default, it is set to 1000. Increasing the number substantially
is not recommended as it will take longer to produce all the intervals and
store them into a dataframe.}

\item{table}{Indicates whether or not a table output with some relevant
statistics should be generated. The default is TRUE and generates a table
which is included in the list object.}
}
\value{
A list with 3 items where the dataframe of values is in the first
object, the values needed to calculate the density function in the second,
and the table for the values in the third if table = TRUE.
}
\description{
Computes thousands of consonance (confidence) intervals for the chosen
parameter in the meta-analysis done by the metafor package and places the
interval limits for each interval level into a data frame along with the
corresponding p-values and s-values.
}
\examples{

# Simulate random data for two groups in two studies
GroupAData <- runif(20, min = 0, max = 100)
GroupAMean <- round(mean(GroupAData), digits = 2)
GroupASD <- round(sd(GroupAData), digits = 2)

GroupBData <- runif(20, min = 0, max = 100)
GroupBMean <- round(mean(GroupBData), digits = 2)
GroupBSD <- round(sd(GroupBData), digits = 2)

GroupCData <- runif(20, min = 0, max = 100)
GroupCMean <- round(mean(GroupCData), digits = 2)
GroupCSD <- round(sd(GroupCData), digits = 2)

GroupDData <- runif(20, min = 0, max = 100)
GroupDMean <- round(mean(GroupDData), digits = 2)
GroupDSD <- round(sd(GroupDData), digits = 2)

# Combine the data

StudyName <- c("Study1", "Study2")
MeanTreatment <- c(GroupAMean, GroupCMean)
MeanControl <- c(GroupBMean, GroupDMean)
SDTreatment <- c(GroupASD, GroupCSD)
SDControl <- c(GroupBSD, GroupDSD)
NTreatment <- c(20, 20)
NControl <- c(20, 20)

metadf <- data.frame(
  StudyName, MeanTreatment, MeanControl,
  SDTreatment, SDControl, NTreatment, NControl
)

# Use metafor to calculate the standardized mean difference

library(metafor)

dat <- escalc(
  measure = "SMD", m1i = MeanTreatment, sd1i = SDTreatment,
  n1i = NTreatment, m2i = MeanControl, sd2i = SDControl,
  n2i = NControl, data = metadf
)

# Pool the data using a particular method. Here "FE" is the fixed-effects model

res <- rma(yi, vi,
  data = dat, slab = paste(StudyName, sep = ", "),
  method = "FE", digits = 2
)

# Calculate the intervals using the metainterval function

metaf <- curve_meta(res)
}
