% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_bin.R
\name{run_bin}
\alias{run_bin}
\title{Run a Binary from a Conda Environment Without Environment Activation}
\usage{
run_bin(
  cmd,
  ...,
  env_name = "condathis-env",
  verbose = "silent",
  error = c("cancel", "continue"),
  stdout = "|",
  stderr = "|"
)
}
\arguments{
\item{cmd}{Character. The main command to be executed in the Conda environment.}

\item{...}{Additional arguments to be passed to the command. These arguments will be passed directly to the command executed in the Conda environment.
File paths should not contain special characters or spaces.}

\item{env_name}{Character. The name of the Conda environment where the tool will be run. Defaults to \code{"condathis-env"}.
If the specified environment does not exist, it will be created automatically using \code{create_env()}.}

\item{verbose}{Character string specifying the verbosity level of the function's output. Acceptable values are:
\itemize{
\item \strong{"silent"}: Suppress all output from internal command-line tools. Equivalent to \code{FALSE}.
\item \strong{"cmd"}: Print the internal command(s) passed to the command-line tool.
\item \strong{"output"}: Print the standard output and error from the command-line tool to the screen. Note that the order of the standard output and error lines may not be correct, as standard output is typically buffered. If the standard output and/or error is redirected to a file or they are ignored, they will not be echoed.
\item \strong{"full"}: Print both the internal command(s) (\code{"cmd"}) and their standard output and error (\code{"output"}). Equivalent to \code{TRUE}.
Logical values \code{FALSE} and \code{TRUE} are also accepted for backward compatibility but are \emph{soft-deprecated}. Please use \code{"silent"} and \code{"full"} respectively instead.
}}

\item{error}{Character string. How to handle errors. Options are \code{"cancel"} or \code{"continue"}. Defaults to \code{"cancel"}.}

\item{stdout}{Default: "|" keep stdout to the R object
returned by \code{run()}.
A character string can be used to define a file path to be used as standard output. e.g: "output.txt".}

\item{stderr}{Default: "|" keep stderr to the R object
returned by \code{run()}.
A character string can be used to define a file path to be used as standard error. e.g: "error.txt".}
}
\value{
An object of class \code{list} representing the result of the command
execution. Contains information about the standard output, standard error,
and exit status of the command.
}
\description{
Executes a binary command from a specified Conda environment without
activating the environment or using its environment variables.
This function temporarily clears Conda and Mamba-related environment
variables to prevent interference, ensuring that the command runs in a clean
environment.
Usually this is not what the user wants as this mode of execution does not
load environment variables and scripts defined in the environment
\code{activate.d}, check \code{\link[=run]{run()}} for the stable function to use.
}
\examples{
\dontrun{
condathis::with_sandbox_dir({
  # Example assumes that 'my-env' exists and contains 'python'
  # Run 'python' with a script in 'my-env' environment
  condathis::run_bin(
    "python", "-c", "import sys; print(sys.version)",
    env_name = "my-env",
    verbose = "output"
  )

  # Run 'ls' command with additional arguments
  condathis::run_bin("ls", "-la", env_name = "my-env")
})
}

}
