% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{eval.config.sections}
\alias{eval.config.sections}
\title{Get config file parameter sections}
\usage{
eval.config.sections(file = Sys.getenv("R_CONFIGFILE_ACTIVE", "config.cfg"),
  ...)
}
\arguments{
\item{file}{File name of configuration file to read from. Default is the value of
the 'R_CONFIGFILE_ACTIVE' environment variable (Set to 'config.cfg' if the
variable does not exist and JSON/INI/YAML/TOML format only)}

\item{...}{Arguments for \code{\link{read.config}}}
}
\value{
a character vector including the sections infomation of configure file or
logical FALSE indicating that is not standard JSON/INI/YAML/TOML format file
}
\description{
Get config file parameter sections
}
\examples{
config.json <- system.file('extdata', 'config.json', package='configr')
eval.config.sections(config.json)
}
\seealso{
\code{\link{eval.config.merge}} use this function to get all of sections of config file.
}
