% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standard_errors.R
\name{se}
\alias{se}
\alias{se_mean}
\alias{se_mean_diff}
\alias{se_var}
\alias{se_proportion}
\title{Standard errors}
\usage{
se_mean(z, na.rm = TRUE, ...)

se_mean_diff(z, y, na.rm = TRUE, var.equal = FALSE, ...)

se_var(z, na.rm = TRUE, ...)

se_proportion(z, na.rm = TRUE, ...)
}
\arguments{
\item{z}{Numeric vector.}

\item{na.rm}{Should missing values be removed before calculation?
The default is \code{TRUE} for convenience.}

\item{...}{Further arguments to be passed from other methods.}

\item{y}{Numeric vector.}

\item{var.equal}{Should the two variances be treated as being equal?
The default is \code{FALSE}. If \code{TRUE}, the pooled variance is used to estimate the
variance of the mean difference. Otherweise, Welch's approach is used
(see \code{\link[stats:t.test]{stats::t.test()}}). This also applies to the "stud" bootstrap.}
}
\value{
A numeric vector of length one.
}
\description{
Functions to calculate standard errors of different statistics.
The availability of a standard error (or statistic proportional to it) allows to
apply "stud" (bootstrap t) bootstrap.
}
\examples{
se_mean(1:100)
}
