% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen_senator_details.R
\name{sen_senator_suplentes}
\alias{sen_senator_suplentes}
\title{Downloads and tidies information on titular senators and their
\emph{suplentes} in the Federal Senate}
\usage{
sen_senator_suplentes(id = 0, ascii = TRUE)
}
\arguments{
\item{id}{\code{integer}. This number represents the id of the senator
you wish to get information on. These ids can be extracted from the API
using the \code{sen_senator_list()} function, where they will appear as the
first column in the data frame returned, under the name 'id'.}

\item{ascii}{\code{logical}. If TRUE, certain strings are converted to ascii
format.}
}
\value{
A tibble, of classes \code{tbl_df}, \code{tbl} and \code{data.frame}.
}
\description{
Downloads and tidies information on titular senators and their
\emph{suplentes} in the Federal Senate.
}
\examples{
# A titular senator, José Serra:
Serra <- sen_senator_suplentes(id = 90)

# Or one of his suplentes:
suplente <- sen_senator_suplentes(id = 878)

}
\seealso{
\code{sen_senator_list()}
}
\author{
Robert Myles McDonnell, Guilherme Jardim Duarte & Danilo Freire.
}
