#' A function for reading LaTeX files
#'
#' @param file is the name of a file with .tex extension. The .tex file must be generated by R Sweave using package 'knitr'.
#' @param filepath is the absolute filepath where .tex file is located.
#' @export
#' @return \code{read.latex} returns two character strings: tex and path, both of which are used by \code{write.rtf}.
#' @seealso \code{\link{write.rtf}}
#' @examples
#' #Read a sample LaTeX file
#' file<-'connect3-minimal.tex'
#' filepath<-paste(sub("examples/.*","\\1",
#'           system.file("examples","connect3-minimal.tex",package="connect3")),
#'           "examples", sep='')
#' obj<-read.latex(file, filepath)
#' obj$tex
#' obj$path

read.latex<-function(file, filepath){
  filepath<-setwd(filepath)
  obj<-readLines(file)
  obj<-paste(obj, sep="", collapse="Connect3Line ")
  obj<-gsub("Connect3Line", "Connect3END Connect3BEGIN", obj )
  obj<-paste("Connect3BEGIN", obj, "Connect3END")
  return(list(tex = obj, path = filepath))
}

