% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRout.R
\name{plotRout}
\alias{plotRout}
\alias{plotRout.TestInfo}
\alias{plotRout.InformationWithLatentDist}
\alias{plotRout.ICC}
\alias{plotRout.MCC}
\alias{plotRout.default}
\title{plotRout}
\usage{
plotRout(myRout, ...)

\method{plotRout}{TestInfo}(myRout, ...)

\method{plotRout}{InformationWithLatentDist}(myRout, ...)

\method{plotRout}{ICC}(myRout, ...)

\method{plotRout}{MCC}(myRout, ...)

\method{plotRout}{default}(myRout, ...)
}
\arguments{
\item{myRout}{an R object created by the `ConQuestRout` function.}

\item{...}{additional arguments passed into plotting functions (e.g., `plotZero = TRUE` to control whether the 0 category is plotted in ICC and MCC).}
}
\value{
A ggplot2 object.
}
\description{
generates a plot from an 'ACER ConQuest' Rout file. use `ConQuestRout` to read in an Rout
 file created by a `plot` command in 'ACER ConQuest'.
}
\examples{
myPlot<- plotRout(ConQuestRout())
\dontrun{
# if you run the above example you will have a ggplot2 object, using the default Rout file (an ICC).
str(myPlot)
}
## to see why we import this, see https://ggplot2.tidyverse.org/articles/ggplot2-in-packages.html
}
