% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McNemar_exact_unconditional_test_paired_2x2.R
\name{McNemar_exact_unconditional_test_paired_2x2}
\alias{McNemar_exact_unconditional_test_paired_2x2}
\title{The McNemar exact unconditional test}
\usage{
McNemar_exact_unconditional_test_paired_2x2(n, gamma = 1e-04)
}
\arguments{
\item{n}{the observed table (a 2x2 matrix)}

\item{gamma}{parameter for the Berger and Boos procedure (default=0.0001; gamma=0: no adj)}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The McNemar exact unconditional test

Described in Chapter 8 "The Paired 2x2 Table"
}
\note{
Somewhat crude code with maximization over a simple partition of the
nuisance parameter space into 'num_pi_values' equally spaced values
(default: 1000). The number may be changed below. This method could be
improved with a better algorithm for the maximization; however, it works
well for most purposes. Try \code{showplot=1} to get an indication of
the precision. A refinement of the maximization can be done with a manual
restriction of the parameter space.
}
\examples{
McNemar_exact_unconditional_test_paired_2x2(bentur_2009)
McNemar_exact_unconditional_test_paired_2x2(cavo_2012, gamma = 0)
\dontrun{McNemar_exact_unconditional_test_paired_2x2(ezra_2010)}
}
