% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCt.r
\name{plotCt}
\alias{plotCt}
\title{Plots calcConv or convSig output.}
\usage{
plotCt(
  output,
  phy,
  focaltaxa,
  nsim = 25,
  col = c("black", "forest green", "dodgerblue2", "firebrick1", "purple", "orange",
    "salmon", "goldenrod", "springgreen2", "plum1"),
  groups = NULL,
  ...
)
}
\arguments{
\item{output}{object containing calcConv or convSig output}

\item{phy}{The time calibrated phylogeny of interest in phylo format}

\item{focaltaxa}{a vector of tip labels for the putatively convergent taxa to be compared}

\item{nsim}{number of null simulations to plot}

\item{col}{vector of colors to use for all unique intergroup comparisons a default option is given usable with up to five groups. If number of groups is 1 or less than length of col, not all colors will be used}

\item{groups}{an optional vector of groups with names matching focaltaxa, indicating the group identity of all focaltaxa}

\item{...}{optional arguments to be passed to tiplabels}
}
\value{
A plot identifying putatively convergent taxa in the provided phylogeny and tracking the change in phenotypic distance between taxa since their most recent common ancestor
}
\description{
plotCt Plots calcConv or convSig output.
}
\details{
Creates a plot that shows the phenotypic distances between pairs of putatively convergent lineages over time. When these distances decrease, convergence has occurred. When more than two putatively
convergent taxa are analyzed, all pairs are plotted.
}
\examples{

\donttest{#' create time calibrated tree
phy<-rcoal(100)

# create three normally distributed phenotypic traits
traits <- cbind(rnorm(Ntip(phy)),rnorm(Ntip(phy)),rnorm(Ntip(phy)))
rownames(traits) <- phy$tip.label
focaltaxa <- sample(phy$tip.label, 5)

system.time(run2 <- convSigCt(phy, traits, focaltaxa, nsim=10))

plotCt(output = run2,phy = phy,focaltaxa = focaltaxa)}
}
\references{
Grossnickle DM, Brightly WH, Weaver LN, Stanchak KE, Roston RA, Pevsner SK, Stayton CT, Polly PD, Law CJ. 2022. A cautionary note on quantitative measures of phenotypic convergence. in revision
Zelditch ML, Ye J, Mitchell JS, Swiderski DL. 2017. Rare ecomorphological convergence on a complex adaptive landscape: Body size and diet mediate evolution of jaw shape in squirrels (Sciuridae). Evolution 71: 633-649
Stayton CT. 2015. The definition, recognition, and interpretation of convergent evolution and two new measures for quantifying and assessing the significance of convergence. Evolution 69(8): 2140-2153.
Revell, L. J. (2012) phytools: An R package for phylogenetic comparative biology (and other things). Methods Ecol. Evol., 3, 217-223.
Felsenstein, J. 1985. Phylogenies and the comparative method. American Naturalist, 125, 1-15.
}
