% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mollweide.R
\name{mollweide}
\alias{mollweide}
\title{Mollweide projection}
\usage{
mollweide(lon, lat, lon0 = 0, radius = 1, deg = FALSE)
}
\arguments{
\item{lon}{n-vector of longitudes in radian (unless deg=TRUE)}

\item{lat}{n-vector of latitudes in radian (unless deg=TRUE), must lie between -pi/2 and +pi/2}

\item{lon0}{latitude of null meridian, which will be projected on to x=0}

\item{radius}{radius of spherical projection, such that the surface area of the projection equals 4*pi*radius^2}

\item{deg}{logical flag; if set to TRUE, the input arguments \code{lon}, \code{lat}, \code{lon0} are assumed to be in degrees (otherwise in radians)}
}
\value{
Returns an n-by-2 matrix of 2D Cartesian coordinates \code{x} and \code{y}.
}
\description{
Performs a Mollweide projection (also known as Babinet projection, homalographic projection, homolographic projection, and elliptical projection) of longitude and latitude coordinates. The most important feature of the Mollweide projection is that it preserves surface areas, which makes it a commonly used projection in geography, astronomy and cosmology. The total surface area of the standard projection is equal to the surface area of the unit sphere (4pi); and the shape of the fully projected sphere is an ellipse (with axes lengths 2*sqrt(2) and sqrt(2)).
}
\examples{
lon = runif(1e4,0,2*pi)
lat = asin(runif(1e4,-1,1)) # = uniform sampling of the sphere
plot(mollweide(lon,lat),xlim=c(-3,3),ylim=c(-1.5,1.5),pch=16,cex=0.5)
plotrix::draw.ellipse(0,0,2*sqrt(2),sqrt(2),border='orange',lwd=2)

}
\author{
Danail Obreschkow
}
