% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothcontour.R
\name{smoothcontour}
\alias{smoothcontour}
\title{Draw smoothed contours}
\usage{
smoothcontour(
  x = seq(0, 1, length.out = nrow(z)),
  y = seq(0, 1, length.out = ncol(z)),
  z,
  levels,
  smoothing = 0.5,
  min.radius = 1,
  lwd = 1,
  lty = 1,
  col = "black",
  ...
)
}
\arguments{
\item{x, y}{vectors containing the locations of grid lines at which the values of z are measured. These must be in ascending order. By default, equally spaced values from 0 to 1 are used.}

\item{z}{matrix representing the density field on which the contours are plotted.}

\item{levels}{vector of the iso-contour levels.}

\item{smoothing}{value between 0 and 1 specifying the degree of smoothing.}

\item{min.radius}{numerical value. If larger than 0, all contours with a mean radius (in pixels) below \code{min.radius} are removed.}

\item{lwd}{vector of line widths (see \code{\link[graphics]{par}})}

\item{lty}{vector of line types (see \code{\link[graphics]{par}})}

\item{col}{vector of colors (see \code{\link[graphics]{par}})}

\item{...}{additional parameters to be passed to the function \code{\link[graphics]{lines}}.}
}
\value{
None
}
\description{
Draw smoothed iso-countours for a density field. The contours are computed using the \code{\link[grDevices]{contourLines}} routine and smoothed using the \code{\link[stats]{smooth.spline}} function. Both open and closed contour lines are handled correctly.
}
\examples{
set.seed(1)
f = function(x) cos(2*x[1]-x[2]-1)^2*exp(-x[1]^2-x[2]^2-x[1]*x[2])
x = seq(-3,3,length=100)
m = pracma::meshgrid(x)
z = array(Vectorize(function(x,y) f(c(x,y)))(m$Y,m$X)+rnorm(4e4,sd=0.1),dim(m$X))
image(x,x,z,col=terrain.colors(100))
contour(x,x,z,levels=c(0.2,0.5),add=TRUE)
smoothcontour(x,x,z,levels=c(0.2,0.5),lwd=3,smoothing=0.8,min.radius=2)

}
\seealso{
\code{\link[grDevices]{contourLines}}, \code{\link[stats]{smooth.spline}}
}
\author{
Danail Obreschkow
}
