\name{EMPIRgridder2}
\alias{EMPIRgridder2}
\title{ Derivatives of the Grid of the Bivariate Emprical Copula }
\description{
Generate a gridded representation of the bivariate empirical copula.
}
\usage{
EMPIRgridder2(empgrid=NULL, ...)
}
\arguments{
  \item{empgrid}{The grid from \code{\link{EMPIRgrid}}, and}
  \item{...}{Additional arguments to pass.}
}
\value{
  The gridded values of 
}
\author{ W.H. Asquith }
\seealso{ \code{\link{EMPIRcop}}, \code{\link{EMPIRcopdf}}, \code{\link{EMPIRgrid}}, \code{\link{EMPIRgridder}} }
\examples{
\dontrun{
para   <- list(alpha=.15,  beta=.65,
               cop1=PLACKETTcop, cop2=PLACKETTcop,
               para1=.005, para2=1000)
uv <- simCOP(n=1000, cop=composite2COP, para=para)
fakeU <- pp(uv[,1], sort=FALSE)
fakeV <- pp(uv[,2], sort=FALSE)
uv <- data.frame(U=fakeU, V=fakeV)

"trans3d" <- function(x,y,z, pmat) {
   tmat <- cbind(x,y,z,1) %*% pmat;
   return(tmat[,1:2] / tmat[,4]);
}

the.grid <- EMPIRgrid(para=uv, deluv=.1)
the.diag <- diagCOP(cop=EMPIRcop, para=uv, ploton=FALSE, lines=FALSE)
empcop <- EMPIRcopdf(para=uv) # data frame of all points

the.persp <- persp(the.grid$empcop,
                   theta=-25, phi=20,
              xlab="U VARIABLE", ylab="V VARIABLE", zlab="COPULA C(u,v)")
points(trans3d(empcop$u, empcop$v, empcop$empcop, the.persp),
       col=rgb(0,1-sqrt(empcop$empcop),1,sqrt(empcop$empcop)),
       pch=16, cex=0.75)
some.lines <- trans3d(rep(0.2, length(the.grid$v)),
                      the.grid$v, the.grid$empcop[3,], the.persp)
lines(some.lines, lwd=2, col=2) 
some.lines <- trans3d(the.grid$u, rep(0.6, length(the.grid$u)),
                      the.grid$empcop[,7], the.persp)
lines(some.lines, lwd=2, col=3) 
some.lines <- trans3d(rep(0.7, length(the.grid$v)), the.grid$v,
                      the.grid$empcop[8,], the.persp)
lines(some.lines, lwd=2, col=6) 


empder <- EMPIRgridder(empgrid=the.grid)
some.lines <- trans3d(rep(0.2, length(the.grid$v)), the.grid$v,
                      empder[3,], the.persp)
lines(some.lines, lwd=4, col=2) 

empder <- EMPIRgridder2(empgrid=the.grid)
some.lines <- trans3d(the.grid$u, rep(0.6, length(the.grid$u)),
                      empder[,7], the.persp)
lines(some.lines, lwd=4, col=3) 


empder <- EMPIRgridder(empgrid=the.grid)
some.lines <- trans3d(rep(0.7, length(the.grid$v)), the.grid$v,
                      empder[8,], the.persp)
lines(some.lines, lwd=4, col=6) 

}
}
\keyword{distribution}
\keyword{multivariate}
