% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copCAR.R
\name{summary.copCAR}
\alias{summary.copCAR}
\title{Print a summary of a copCAR model fit.}
\usage{
\method{summary}{copCAR}(object, alpha = 0.05, digits = 4, ...)
}
\arguments{
\item{object}{an object of class \code{copCAR}, the result of a call to \code{\link{copCAR}}.}

\item{alpha}{the significance level for the confidence intervals. The default is 0.05.}

\item{digits}{the number of significant digits to display. The default is 4.}

\item{\dots}{additional arguments.}
}
\description{
Print a summary of a copCAR model fit.
}
\details{
This function displays (1) the call to \code{\link{copCAR}}, (2) the values of the control parameters, (3) a table of estimates, and (when applicable) (4) confidence intervals and (5) Monte Carlo standard errors.

Each row of the table of estimates shows a parameter estimate and (when applicable) the confidence interval for the parameter. If \code{\link{copCAR}} was called with \code{confint = "bootstrap"}, Monte Carlo standard errors are provided.
}
\references{
Flegal, J., Haran, M., and Jones, G. (2008) Markov Chain Monte Carlo: can we trust the third significant figure? \emph{Statistical Science}, \bold{23}(2), 250--260.
}
\seealso{
\code{\link{copCAR}}
}

