/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.common.io.text;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import uno.informatics.common.ConversionUtilities;
import uno.informatics.common.io.RowWriter;
import uno.informatics.common.io.text.AbstractTextFileHandler;

public class TextFileRowWriter
extends AbstractTextFileHandler
implements RowWriter {
    private BufferedWriter bufferedWriter;
    private static final String BUFFERWRITER_NULL = "Buffer writer is undefined";

    public TextFileRowWriter(String reference) throws IOException, FileNotFoundException {
        super(reference);
        this.initialise();
    }

    public TextFileRowWriter(Path path) throws IOException, FileNotFoundException {
        super(path);
        this.initialise();
    }

    public TextFileRowWriter(BufferedWriter bufferedWriter) throws IOException {
        if (bufferedWriter == null) {
            throw new IOException("Buffered writer undefined");
        }
        this.bufferedWriter = bufferedWriter;
        this.initialise();
    }

    @Override
    public final void close() {
        try {
            if (this.bufferedWriter != null) {
                this.bufferedWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.bufferedWriter = null;
    }

    public final void flush() {
        try {
            if (this.bufferedWriter != null) {
                this.bufferedWriter.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public final void writeCellsAsArray(Object[][] cells) throws IOException {
        if (cells != null) {
            this.writeRowCellsAsArray(cells[0]);
            for (int i = 1; i < cells.length; ++i) {
                this.newRow();
                this.writeRowCellsAsArray(cells[i]);
            }
        }
    }

    @Override
    public final void writeCells(List<List<Object>> cells) throws IOException {
        if (cells != null) {
            Iterator<List<Object>> iterator = cells.iterator();
            if (iterator.hasNext()) {
                this.writeRowCells(iterator.next());
                while (iterator.hasNext()) {
                    this.newRow();
                    this.writeRowCells(iterator.next());
                }
            }
            this.bufferedWriter.flush();
        }
    }

    @Override
    public final void writeRowCellsAsArray(Object[] cells) throws IOException {
        if (cells != null) {
            this.writeCell(cells[0]);
            for (int i = 1; i < cells.length; ++i) {
                this.newColumn();
                this.writeCell(cells[i]);
            }
            this.bufferedWriter.flush();
        }
    }

    @Override
    public final void writeRowCells(List<Object> cells) throws IOException {
        if (cells != null) {
            Iterator<Object> iterator = cells.iterator();
            if (iterator.hasNext()) {
                this.writeCell(iterator.next());
                while (iterator.hasNext()) {
                    this.newColumn();
                    this.writeCell(iterator.next());
                }
            }
            this.bufferedWriter.flush();
        }
    }

    @Override
    public final void writeCell(Object cell) throws IOException {
        this.bufferedWriter.write(this.convertValue(cell));
    }

    protected String convertValue(Object value) {
        if (value != null) {
            return ConversionUtilities.convertToString(value);
        }
        return "";
    }

    @Override
    public final boolean newRow() throws IOException {
        this.bufferedWriter.newLine();
        this.incrementRowIndex();
        this.resetCellIndex();
        return true;
    }

    @Override
    public final boolean newColumn() throws IOException {
        this.bufferedWriter.write(this.getDelimiterString());
        this.incrementColumnIndex();
        return true;
    }

    @Override
    protected final void initialise() throws FileNotFoundException, IOException {
        super.initialise();
        if (this.getPathReference() != null) {
            this.initialiseBufferedWriter(TextFileRowWriter.getBufferedWriter(this.getPathReference()));
        } else if (this.getPath() != null) {
            this.initialiseBufferedWriter(TextFileRowWriter.getBufferedWriter(this.getPath()));
        } else if (this.bufferedWriter != null) {
            this.initialiseBufferedWriter(this.bufferedWriter);
        } else {
            throw new IOException("Unable to initialise reader");
        }
    }

    private final void initialiseBufferedWriter(BufferedWriter bufferedWriter) {
        if (bufferedWriter == null) {
            throw new NullPointerException(BUFFERWRITER_NULL);
        }
        this.bufferedWriter = bufferedWriter;
        this.setRowPosition(0);
        this.setCurrentRowSize(-1);
        this.setRowIndex(-1);
    }

    private static final BufferedWriter getBufferedWriter(Path filePath) throws FileNotFoundException, IOException {
        if (filePath != null) {
            return Files.newBufferedWriter(filePath, new OpenOption[0]);
        }
        throw new FileNotFoundException("File object is null");
    }

    private static final BufferedWriter getBufferedWriter(String fileReference) throws FileNotFoundException, IOException {
        BufferedWriter bufferedWriter = null;
        bufferedWriter = new BufferedWriter(new FileWriter(fileReference));
        return bufferedWriter;
    }
}

