% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/udpipe.r
\name{tCorpus$feats_to_columns}
\alias{tCorpus$feats_to_columns}
\alias{feats_to_columms}
\title{Cast the "feats" column in UDpipe tokens to columns}
\arguments{
\item{keep}{Optionally, the names of features to keep}

\item{drop}{Optionally, the names of features to drop}

\item{rm_column}{If TRUE (default), remove the original column}
}
\description{
If the UDpipe parser is used in \code{\link{create_tcorpus}}, the 'feats' column contains strings with features
(e.g, Number=Sing|PronType=Dem). To work with these nested features it is more convenient to cast them to columns.
}
\details{
\strong{Usage:}

## R6 method for class tCorpus. Use as tc$method (where tc is a tCorpus object).

\preformatted{
feats_to_columns(keep=NULL, drop=NULL, rm_column=TRUE)
}
}
\examples{
if (interactive()) {
tc = create_tcorpus('This is a test Bobby.', udpipe_model='english-ewt')
tc$feats_to_columns()
tc$tokens

tc = create_tcorpus('This is a test Bobby.', udpipe_model='english-ewt')
tc$feats_to_columns(keep = c('Gender','Tense','Person'))
tc$tokens
}
}
