# test_misc.R

context("Make sure 'order' and 'abs' return correct matrix")

# cmat0 <- corrgram(mtcars)

cmat10 <- corrgram(mtcars, lower.panel = panel.conf, order = TRUE)

cmat11 <- structure(c(1, 0.794, 0.7, 0.48, 0.206, -0.213, -0.583, -0.556, 
-0.493, -0.126, 0.274, 0.794, 1, 0.713, 0.6, 0.168, -0.23, -0.692, 
-0.591, -0.523, -0.243, 0.058, 0.7, 0.713, 1, 0.681, 0.44, 0.091, 
-0.712, -0.71, -0.7, -0.449, -0.091, 0.48, 0.6, 0.681, 1, 0.664, 
0.419, -0.868, -0.848, -0.852, -0.776, -0.551, 0.206, 0.168, 
0.44, 0.664, 1, 0.745, -0.555, -0.71, -0.811, -0.723, -0.57, 
-0.213, -0.23, 0.091, 0.419, 0.745, 1, -0.175, -0.434, -0.591, 
-0.708, -0.656, -0.583, -0.692, -0.712, -0.868, -0.555, -0.175, 
1, 0.888, 0.782, 0.659, 0.428, -0.556, -0.591, -0.71, -0.848, 
-0.71, -0.434, 0.888, 1, 0.902, 0.791, 0.395, -0.493, -0.523, 
-0.7, -0.852, -0.811, -0.591, 0.782, 0.902, 1, 0.832, 0.527, 
-0.126, -0.243, -0.449, -0.776, -0.723, -0.708, 0.659, 0.791, 
0.832, 1, 0.75, 0.274, 0.058, -0.091, -0.551, -0.57, -0.656, 
0.428, 0.395, 0.527, 0.75, 1), .Dim = c(11L, 11L), .Dimnames = list(
    c("gear", "am", "drat", "mpg", "vs", "qsec", "wt", "disp", 
    "cyl", "hp", "carb"), c("gear", "am", "drat", "mpg", "vs", 
    "qsec", "wt", "disp", "cyl", "hp", "carb")))

test_that("'order' returns correct matrix", {
  expect_equal(round(cmat10,3), cmat11)
})

cmat20 <- corrgram(mtcars, lower.panel = panel.conf, abs = TRUE)

cmat21 <- structure(c(1, -0.85, -0.85, -0.78, 0.68, -0.87, 0.42, 0.66, 
0.6, 0.48, -0.55, -0.85, 1, 0.9, 0.83, -0.7, 0.78, -0.59, -0.81, 
-0.52, -0.49, 0.53, -0.85, 0.9, 1, 0.79, -0.71, 0.89, -0.43, 
-0.71, -0.59, -0.56, 0.39, -0.78, 0.83, 0.79, 1, -0.45, 0.66, 
-0.71, -0.72, -0.24, -0.13, 0.75, 0.68, -0.7, -0.71, -0.45, 1, 
-0.71, 0.09, 0.44, 0.71, 0.7, -0.09, -0.87, 0.78, 0.89, 0.66, 
-0.71, 1, -0.17, -0.55, -0.69, -0.58, 0.43, 0.42, -0.59, -0.43, 
-0.71, 0.09, -0.17, 1, 0.74, -0.23, -0.21, -0.66, 0.66, -0.81, 
-0.71, -0.72, 0.44, -0.55, 0.74, 1, 0.17, 0.21, -0.57, 0.6, -0.52, 
-0.59, -0.24, 0.71, -0.69, -0.23, 0.17, 1, 0.79, 0.06, 0.48, 
-0.49, -0.56, -0.13, 0.7, -0.58, -0.21, 0.21, 0.79, 1, 0.27, 
-0.55, 0.53, 0.39, 0.75, -0.09, 0.43, -0.66, -0.57, 0.06, 0.27, 
1), .Dim = c(11L, 11L), .Dimnames = list(c("mpg", "cyl", "disp", 
"hp", "drat", "wt", "qsec", "vs", "am", "gear", "carb"), c("mpg", 
"cyl", "disp", "hp", "drat", "wt", "qsec", "vs", "am", "gear", 
"carb")))

test_that("'abs' returns correct matrix", {
  expect_equal(round(cmat20,2), cmat21)
})
