% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{round_floor}
\alias{round_floor}
\title{Rounding function}
\usage{
round_floor(z, y_max = Inf)
}
\arguments{
\item{z}{the real-valued input(s)}

\item{y_max}{a fixed and known upper bound for all observations; default is \code{Inf}}
}
\value{
The count-valued output(s) from the rounding function.
}
\description{
Define the rounding operator associated with the floor function. The function
also returns zero whenever the input is negative and caps the value at \code{y_max},
where \code{y_max} is a known upper bound on the data \code{y} (if specified).
}
\examples{

# Floor function:
round_floor(1.5)
round_floor(0.5)

# Special treatmeant of negative numbers:
round_floor(-1)

}
