% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_parts.R
\name{middle}
\alias{middle}
\alias{tails}
\alias{lower}
\alias{upper}
\title{Find a percentage of a distribution}
\usage{
middle(x, prop = 0.95, greedy = TRUE)

tails(x, prop = 0.95, greedy = TRUE)

lower(x, prop = 0.025, greedy = TRUE)

upper(x, prop = 0.025, greedy = TRUE)
}
\arguments{
\item{x}{The distribution of values to check.}

\item{prop}{The proportion of values to find.}

\item{greedy}{Whether the function should be greedy, as per the description above.}
}
\value{
A logical vector indicating which values are in the specified region.
}
\description{
Given a distribution, find which values lie in the upper, lower, or middle proportion of the
distribution. Useful when you want to do something like shade in the middle 95\% of a plot. This
is a greedy operation, meaning that if the cutoff point is between two whole numbers the
specified region will suck up the extra space. For example, the requesting the upper 30\% of the
\verb{[1 2 3 4]} will return \verb{[FALSE FALSE TRUE TRUE]} because the 30\% was greedy.
}
\details{
Note that \code{NA} values are ignored, i.e. they will always return \code{FALSE}.
}
\examples{

upper(1:10, .1)
lower(1:10, .2)
middle(1:10, .5)
tails(1:10, .5)

sampling_distribution <- do(1000) * mean(rnorm(100, 5, 10))
sampling_distribution \%>\%
  gf_histogram(~mean, data = sampling_distribution, fill = ~ middle(mean, .68)) \%>\%
  gf_refine(scale_fill_manual(values = c("blue", "coral")))
}
