% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refresh_covid19mobility_google.R
\name{refresh_covid19mobility_google_subregions}
\alias{refresh_covid19mobility_google_subregions}
\title{Get Google Mobility Data at the State of Subdivision Level}
\usage{
refresh_covid19mobility_google_subregions()
}
\value{
A tibble meeting the Covid19R Project data standard. Columns include:
\itemize{
\item date - The date in YYYY-MM-DD form
\item location - The name of the location as provided by the data source.
\item location_type - The type of location using the covid19R controlled vocabulary.
\item location_code - A standardized location code using a national or international standard. In this case, FIPS state or county codes. See https://en.wikipedia.org/wiki/Federal_Information_Processing_Standard_state_code and https://en.wikipedia.org/wiki/FIPS_county_code for more
\item location_code_type The type of standardized location code being used according to the covid19R controlled vocabulary. Here we use \code{iso_3166_2}
\item data_type - the type of data in that given row. See description.
\item value - number of cases of each data type
}
}
\description{
From Google:
"Each Community Mobility Report dataset is presented by location
and highlights the percent change in visits to places like grocery
stores and parks within a geographic area.

Location accuracy and the understanding of categorized places
varies from region to region, so we don’t recommend using this
data to compare changes between countries, or between regions
with different characteristics (e.g. rural versus urban areas).

Changes for each day are compared to a baseline value for that
day of the week: The baseline is the median value, for the corresponding day
of the week, during the 5-week period Jan 3–Feb 6, 2020.
The datasets show trends over several months with the most
recent data representing approximately 2-3 days ago—this is how
long it takes to produce the datasets."

Data represents changes from baseline visits for the following types
of locations visited:
\itemize{
\item retail and recreation
\item grocery and pharmacy
\item parks
\item transit stations
\item workplaces
\item residential
}
}
\examples{
\donttest{
covid19mobility_google_subregions <- refresh_covid19mobility_google_subregions()

head(covid19mobility_google_subregions)
}

}
\references{
Google Covid-19 Mobility Reports \url{https://www.google.com/covid19/mobility/}

The Covid19R Project \url{https://covid19r.github.io/documentation/}
}
