% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert_or_assign.R
\name{insert_or_assign}
\alias{insert_or_assign}
\alias{insert_or_assign,CppMap-method}
\alias{insert_or_assign,CppUnorderedMap-method}
\title{Add or overwrite elements}
\usage{
insert_or_assign(x, values, keys)
}
\arguments{
\item{x}{A CppMap or CppUnorderedMap object.}

\item{values}{Values to add to \code{x}.}

\item{keys}{Keys to add to \code{x}.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Add elements to a container by reference. Overwrites existing container values tied to the same keys.
}
\details{
Use \link{insert} to avoid overwriting values.
}
\examples{
m <- cpp_map(4:6, 9:11)
m
# [4,9] [5,10] [6,11]

insert_or_assign(m, 12:13, 6:7)
m
# [4,9] [5,10] [6,12] [7,13]

}
\seealso{
\link{insert}, \link{insert_after}, \code{emplace}, \code{try_emplace}.
}
