% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitAndTestCox.R
\name{simpleCox}
\alias{simpleCox}
\alias{fitCox}
\title{Cox model for each type of event separately}
\usage{
fitCox(time, risk, group, cens = NULL, conf.int = 0.95)
}
\arguments{
\item{time}{vector with times of the first event or follow-up, must be numeric.}

\item{risk}{vector with type of event, can be numeric or factor/character.}

\item{group}{vector with group variable, can be numeric or factor/character.}

\item{cens}{value of 'risk' indicating censored observation (if NULL, the first value of 'risk' vector will be taken).}

\item{conf.int}{conf.int level of two-sided confidence interval (default = 0.95).}
}
\value{
a list of length n, where n is number of risks. Each element of a list is a result of summary.coxph function from package survival, where there is only one type of event possible (other are treating as censored).
}
\description{
fits Cox models for each risk and group, treating other type of events as censoring.
}
\examples{
fitCox(time = LUAD$time, risk = LUAD$event, group = LUAD$gender, cens = "alive", conf.int = 0.95)
}
\seealso{
\code{\link[survival]{coxph}}  \code{\link[survival]{summary.coxph}}
}
