% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.R
\name{mcmc_mix2_wrapper}
\alias{mcmc_mix2_wrapper}
\title{Wrapper of mcmc_mix2}
\usage{
mcmc_mix2_wrapper(
  df,
  seed,
  u_max = 2000L,
  log_diff_max = 11,
  a_psiu = 0.001,
  b_psiu = 0.9,
  m_alpha = 0,
  s_alpha = 10,
  a_theta = 1,
  b_theta = 1,
  m_shape = 0,
  s_shape = 10,
  a_sigma = 1,
  b_sigma = 0.01,
  a_pseudo = 10,
  b_pseudo = 1,
  pr_power = 0.5,
  positive = FALSE,
  iter = 20000L,
  thin = 20L,
  burn = 100000L,
  freq = 1000L,
  invts = 1,
  mc3_or_marg = TRUE,
  constrained = FALSE
)
}
\arguments{
\item{df}{A data frame with at least two columns, x & count}

\item{seed}{Integer for \code{set.seed}}

\item{u_max}{Scalar (default 2000), positive integer for the maximum threshold to be passed to \code{obtain_u_set_mix2}}

\item{log_diff_max}{Positive real number, the value such that thresholds with profile posterior density not less than the maximum posterior density - \code{log_diff_max} will be kept}

\item{a_psiu, b_psiu, m_alpha, s_alpha, a_theta, b_theta, m_shape, s_shape, a_sigma, b_sigma}{Scalars, real numbers representing the hyperparameters of the prior distributions for the respective parameters. See details for the specification of the priors.}

\item{a_pseudo}{Positive real number, first parameter of the pseudoprior beta distribution for theta in model selection; ignored if pr_power = 1.0}

\item{b_pseudo}{Positive real number, second parameter of the pseudoprior beta distribution for theta in model selection; ignored if pr_power = 1.0}

\item{pr_power}{Real number in [0, 1], prior probability of the discrete power law (below u)}

\item{positive}{Boolean, is alpha positive (TRUE) or unbounded (FALSE)?}

\item{iter}{Positive integer representing the length of the MCMC output}

\item{thin}{Positive integer representing the thinning in the MCMC}

\item{burn}{Non-negative integer representing the burn-in of the MCMC}

\item{freq}{Positive integer representing the frequency of the sampled values being printed}

\item{invts}{Vector of the inverse temperatures for Metropolis-coupled MCMC (if mc3_or_marg = TRUE) or power posterior (if mc3_or_marg = FALSE)}

\item{mc3_or_marg}{Boolean, is Metropolis-coupled MCMC to be used? Ignored if invts = c(1.0)}

\item{constrained}{Boolean, are alpha & shape constrained such that 1/shape+1 > alpha > 1 with the powerlaw assumed in the body & "continuity" at the threshold u (TRUE), or is there no constraint between alpha & shape, with the former governed by positive, and no powerlaw and continuity enforced (FALSE, default)?}
}
\value{
A list returned by \code{mcmc_mix2}
}
\description{
Wrapper of mcmc_mix2
}
