% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crwN2ll.R
\name{crwN2ll}
\alias{crwN2ll}
\title{-2 * log-likelihood for CTCRW models}
\usage{
crwN2ll(theta, fixPar, y, noObs, delta, a, P, mov.mf, err.mfX, err.mfY,
  rho = NULL, activity = NULL, n.errX, n.errY, n.mov, driftMod, prior,
  need.hess, constr = list(lower = -Inf, upper = Inf))
}
\arguments{
\item{theta}{parameter values.}

\item{fixPar}{values of parameters held fixed (contains \code{NA} for
\code{theta} values).}

\item{y}{N by 2 matrix of coordinates with the longitude coordinate in the first column.}

\item{noObs}{vector with 1 for unobserved locations, and 0 for observed locations.}

\item{delta}{time difference to next location.}

\item{a}{initial state mean.}

\item{P}{intial state covariance matrix}

\item{mov.mf}{Movement covariate data.}

\item{err.mfX}{longitude error covariate data.}

\item{err.mfY}{latitude error covariate data.}

\item{rho}{A vector of known correlation coefficients for the error model, typically used for modern ARGOS data.}

\item{activity}{Stopping covariate (= 0 if animal is not moving).}

\item{n.errX}{number or longitude error parameters.}

\item{n.errY}{number of latitude error parameters.}

\item{n.mov}{number or movement parameters.}

\item{driftMod}{Logical. inicates whether a drift model is specified.}

\item{prior}{Function of theta that returns the log-density of the prior}

\item{need.hess}{Whether or not the Hessian will need to be calculated from
this call}

\item{constr}{Named list giving the parameter constraints}
}
\value{
-2 * log-likelihood value for specified CTCRW model.
}
\description{
This function is designed for primary use within the \code{\link{crwMLE}}
model fitting function. But, it can be accessed for advanced \code{R} and
\code{crawl} users. Uses the state-space parameterization and Kalman filter
method presented in Johnson et al. (2008).
}
\details{
This function calls compiled C++ code which can be viewed in the
\code{src} directory of the crawl source package.
}
\author{
Devin S. Johnson
}
\references{
Johnson, D., J. London, M. -A. Lea, and J. Durban. 2008.
Continuous-time model for animal telemetry data. Ecology 89:1208-1215.
}
\seealso{
\code{\link{crwMLE}}
}

