% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_path.R
\name{get_mask_segments}
\alias{get_mask_segments}
\title{Identify segments of a path that cross through a restricted area}
\usage{
get_mask_segments(crw_object, vector_mask)
}
\arguments{
\item{crw_object}{A \code{crwIS} object from the \code{crawl} package}

\item{vector_mask}{A \code{sf} object from sf package that indicates 
restricted areas as a polygon feature.}
}
\value{
A data.frame with each row associated with each section of the path
that crosses a restricted area. The columns provide the start and end row indices of \code{xy} where
the section occurs and the previous and post locations that are in unrestricted space.
}
\description{
This function is used to identify sections of a path that pass through 
a restricted area (e.g. for marine mammals or fish, a land mask). the CTCRW model in 
crawl cannot actively steer paths away 
from land. So, this function
will identify path segments from the unrestrained path that pass through these areas.
If the path/points end within the land area, those records will be removed.
The user can then use this information to adjust the path as desired.
}
\author{
Josh M. London (josh.london@noaa.gov)
}
