% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick_colors.R
\name{pick_colors}
\alias{pick_colors}
\alias{color_distance}
\alias{color_order}
\title{Heuristics for Color Distances and Locations}
\usage{
pick_colors(hex, n)

color_distance(hex)

color_order(hex)
}
\arguments{
\item{hex}{a character vector of hexadecimal colors}

\item{n}{the integer number of desired colors}
}
\value{
a character vector that is a subset of \code{hex}, or a
matrix of distances for \code{color_distance()}
}
\description{
\itemize{
\item \code{pick_colors()} places each color into RGB space, clusters them with k-means,
and returns the colors nearest each cluster center.
\item \code{color_order()} reorders colors so that subsequent colors are far from each other
in RGB space.
\item \code{color_distance()} calculates pairwise distances in RGB space between colors.
}
}
\examples{
pick_colors(crayons$standard, 10)
color_order(crayons$standard)
color_distance(crayons$standard[1:4])
}
