% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_filter_lasso.R
\name{lasso_filter}
\alias{lasso_filter}
\title{Selected Variables by LASSO}
\usage{
lasso_filter(dat_train, dat_test = NULL, target = NULL,
  x_list = NULL, pos_flag = list(1, "1", "bad"), ex_cols = NULL,
  best_lambda = "lambda.min", sim_sign = "negtive",
  save_data = FALSE, parallel = FALSE, plot.it = TRUE, seed = 46,
  file_name = NULL, dir_path = tempdir())
}
\arguments{
\item{dat_train}{A data.frame with independent variables and target variable.}

\item{dat_test}{A data.frame of test data. Default is NULL.}

\item{target}{The name of target variable.}

\item{x_list}{Names of independent variables.}

\item{pos_flag}{The value of positive class of target variable, default: "1".}

\item{ex_cols}{A list of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{best_lambda}{Best lanmbda stardards. one of ("lambda.min", "lambda.1se", "lambda.05se" , "lambda.sim_sign"). Default is  "lambda.min".}

\item{sim_sign}{The coefficients of all variables should be all negetive or positive, after turning to woe. Default is "negetive" for pos_flag is "1".}

\item{save_data}{Logical, save results in locally specified folder. Default is TRUE}

\item{parallel}{Logical, parallel computing. Default is FALSE.}

\item{plot.it}{Logical, shrinkage plot. Default is TRUE.}

\item{seed}{Random number seed. Default is 46.}

\item{file_name}{The name for periodically saved results files. Default is "Feature_selected_LASSO".}

\item{dir_path}{The path for periodically saved results files. Default is "./variable".}
}
\value{
A list of filtered x variables by lasso.
}
\description{
\code{lasso_filter} filter variables by lasso.
}
\examples{
lasso_filter(dat_train = UCICreditCard[1:1000,c(4,12:15,26)],
            target = "default.payment.next.month",
            best_lambda = "lambda.min", save_data = FALSE,plot.it = FALSE)
}
