% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_relative_freq_histogram}
\alias{plot_relative_freq_histogram}
\title{Plot Relative Frequency Histogram}
\usage{
plot_relative_freq_histogram(dat, x, y = NULL, x_breaks = NULL,
  y_breaks = NULL, g = 10, cut_bin = "equal_width")
}
\arguments{
\item{dat}{A data.frame with independent variables and target variable.}

\item{x}{The name of an independent variable.}

\item{y}{The name of target variable. Default is NULL.}

\item{x_breaks}{Breaks points of x.}

\item{y_breaks}{Breaks points of y.}

\item{g}{Number of initial breakpoints for equal frequency binning.}

\item{cut_bin}{'equal_width' or 'equal_depth' to produce the breaks points.}
}
\description{
You can use the \code{plot_relative_freq_histogram} to produce the relative frequency histogram plots.
}
\examples{
plot_relative_freq_histogram(dat = lendingclub, x = "grade", y = "dti_joint", g = 7,
	cut_bin = 'equal_width')
}
