% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_monitor_sge.R
\name{crew_class_monitor_sge}
\alias{crew_class_monitor_sge}
\title{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} SGE monitor class}
\description{
SGE monitor \code{R6} class
}
\details{
See \code{\link[=crew_monitor_sge]{crew_monitor_sge()}}.
}
\seealso{
Other sge: 
\code{\link{crew_class_launcher_sge}},
\code{\link{crew_controller_sge}()},
\code{\link{crew_launcher_sge}()},
\code{\link{crew_monitor_sge}()}
}
\concept{sge}
\section{Super class}{
\code{\link[crew.cluster:crew_class_monitor_cluster]{crew.cluster::crew_class_monitor_cluster}} -> \code{crew_class_monitor_sge}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_monitor_sge-jobs}{\code{crew_class_monitor_sge$jobs()}}
\item \href{#method-crew_class_monitor_sge-terminate}{\code{crew_class_monitor_sge$terminate()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="crew.cluster" data-topic="crew_class_monitor_cluster" data-id="initialize"><a href='../../crew.cluster/html/crew_class_monitor_cluster.html#method-crew_class_monitor_cluster-initialize'><code>crew.cluster::crew_class_monitor_cluster$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew.cluster" data-topic="crew_class_monitor_cluster" data-id="validate"><a href='../../crew.cluster/html/crew_class_monitor_cluster.html#method-crew_class_monitor_cluster-validate'><code>crew.cluster::crew_class_monitor_cluster$validate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_sge-jobs"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_sge-jobs}{}}}
\subsection{Method \code{jobs()}}{
List SGE jobs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_sge$jobs(user = ps::ps_username())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user}}{Character of length 1, user name of the jobs to list.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{tibble} with one row per SGE job and columns with
specific details.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_sge-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_sge-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate one or more SGE jobs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_sge$terminate(jobs = NULL, all = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jobs}}{Character vector of job names or job IDs to terminate.
Ignored if \code{all} is set to \code{TRUE}.}

\item{\code{all}}{Logical of length 1, whether to terminate all the jobs
under your user name. This terminates ALL your SGE jobs,
regardless of whether \code{crew.cluster} launched them,
so use with caution!}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
