% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_eval.R
\name{crew_eval}
\alias{crew_eval}
\title{Evaluate an R command and return results as a monad.}
\usage{
crew_eval(
  command,
  data = list(),
  globals = list(),
  seed = as.integer(stats::runif(n = 1L, min = 1, max = 1e+09)),
  packages = character(0),
  library = NULL
)
}
\arguments{
\item{command}{Language object with R code to run.}

\item{data}{Named list of local data objects in the evaluation environment.}

\item{globals}{Named list of objects to temporarily assign to the
global environment for the task.}

\item{seed}{Integer of length 1 with the pseudo-random number generator
seed to set for the evaluation of the task. Does not restore
the original seed, but this is okay because \code{crew_eval()}
should only run in a non-interactive worker process.}

\item{packages}{Character vector of packages to load for the task.}

\item{library}{Library path to load the packages. See the \code{lib.loc}
argument of \code{require()}.}
}
\value{
A monad object with results and metadata.
}
\description{
Not a user-side function. Do not call directly.
}
\details{
The \code{crew_eval()} function evaluates an R expression
in an encapsulated environment and returns a monad with the results,
including warnings and error messages if applicable.
The random number generator seed, \code{globals}, and global options
are restored to their original values on exit.
}
\examples{
crew_eval(quote(1 + 1))
}
\seealso{
Other utilities: 
\code{\link{crew_assert}()},
\code{\link{crew_deprecate}()},
\code{\link{crew_random_name}()},
\code{\link{crew_retry}()},
\code{\link{crew_worker}()}
}
\concept{utilities}
\keyword{internal}
