% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/caseUtils.R
\name{makeSeriesData}
\alias{makeSeriesData}
\title{Make crime series data}
\usage{
makeSeriesData(crimedata, offenderTable, time = c("midpoint", "earliest",
  "latest"))
}
\arguments{
\item{crimedata}{data.frame of crime incident data. \code{crimedata} must have
  columns named: \code{crimeID}, \code{DT.FROM}, and \code{DT.TO}}

\item{offenderTable}{offender table that indicates the offender(s) responsible
  for solved crimes. \code{offenderTable} must have columns named:
  \code{offenderID} and \code{crimeID}.}

\item{time}{the event time to be returned: 'midpoint', 'earliest', or
  'latest'}
}
\value{
data.frame representation of the crime series present in the
   \code{crimedata}. It includes the crime ID (\code{crimeID}), index of that
   crimeID in the original \code{crimedata} (\code{Index}), the crime series
   ID (\code{CS}), and the event time (\code{TIME}).
}
\description{
Creates new data.frame with index to crimedata and offender information
}
\details{
The creates a crimeseries data object that is required for creating
   linkage data. It creates a crime series ID numbers (\code{CS}) for every
   offender. Because of co-offending, a single crime (\code{crimeID}) can be
   in multiple crime series.
}
\examples{
data(crimes)
 data(offenders)

 seriesData = makeSeriesData(crimedata=crimes,offenderTable=offenders)
 head(seriesData)

 nCrimes = table(seriesData$offenderID)  # length of each crime series
 table(nCrimes)                  # distribution of crime series length
 mean(nCrimes>1)                 # proportion of offenders with multiple crimes

 nCO = table(seriesData$crimeID) # number of co-offenders per crime
 table(nCO)                      # distribution of number of co-offenders
 mean(nCO>1)                     # proportion of crimes with multiple co-offenders
}
\seealso{
\code{\link{getCrimeSeries}}
}

