% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/naivebayes.R
\name{naiveBayes}
\alias{naiveBayes}
\title{Naive bayes classifier using histograms and shrinkage}
\usage{
naiveBayes(vars, X, df = 20, nbins = 30, partition = c("quantile",
  "width"))
}
\arguments{
\item{vars}{the names or column numbers of specific predictors.}

\item{X}{a data.frame of predictors, can include continuous and
  categorical/factors along with \code{X$type} (linked or unlinked) and
  \code{X$weight}}

\item{df}{the degrees of freedom for each component density. if vector, each
  predictor can use a different df}

\item{nbins}{the number of bins for continuous predictors}

\item{partition}{for binning; indicates if breaks generated from quantiles
  or equal spacing}
}
\value{
BF a bayes factor object; list of component bayes factors
}
\description{
After binning, this adds pseudo counts to each bin count to give
 df approximate degrees of freedom. If partition=quantile, this does not
 assume a continuous uniform prior over support, but rather a discrete uniform
 over all (unlabeled) observations points.
}
\details{
Fits a naive bayes model to continous and categorical/factor predictors.
   Continous predictors are first binned, then estimates shrunk towards zero.
}
\examples{
# See vignette: "Statistical Methods for Crime Series Linkage" for usage.
}

