% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hierclustering.R
\name{crimeClust_hier}
\alias{crimeClust_hier}
\title{Agglomerative Hierarchical Crime Series Clustering}
\usage{
crimeClust_hier(crimedata, varlist, estimateBF, linkage = c("average",
  "single", "complete"), ...)
}
\arguments{
\item{crimedata}{data.frame of crime incidents. Must contain a column named
 \code{crimeID}.}

\item{varlist}{a list of the variable names (columns of \code{crimedata})
 used to create evidence variables with \code{\link{compareCrimes}}.}

\item{estimateBF}{function to estimate the log bayes factor from evidence
 variables}

\item{linkage}{the type of linkage for hierarchical clustering
  \itemize{
    \item \dQuote{average} uses the average bayes factor
    \item \dQuote{single} uses the largest bayes factor (most similar)
    \item \dQuote{complete} uses the smallest bayes factor (least similar)
  }}

\item{\ldots}{other arguments passed to \code{\link{compareCrimes}}}
}
\value{
An object of class \code{hclust} (from \code{\link{hclust}}).
}
\description{
Run hierarchical clustering on a set of crimes using the log Bayes Factor as
the similarity metric.
}
\details{
This function first compares all crime pairs using \code{\link{compareCrimes}},
   then uses \code{estimateBF} to estimate the log Bayes factor for every pair.
   Next, it passes this information into \code{\link{hclust}} to carry out the
   agglomerative hierarchical clustering. Because \code{\link{hclust}} requires
   a dissimilarity, this uses the negative log Bayes factor.

   The input \code{varlist} is a list with elements named: crimeID, spatial,
   temporal, categorical, and numerical. Each element should be a vector of
   the column names of \code{crimedata} corresponding to that feature. See
   \code{\link{compareCrimes}} for more details.
}
\examples{
data(crimes)
 #- cluster the first 10 crime incidents
 crimedata = crimes[1:10,]
 varlist = list(spatial = c("X", "Y"), temporal = c("DT.FROM","DT.TO"),
     categorical = c("MO1",  "MO2", "MO3"))
 estimateBF <- function(X) rnorm(NROW(X))   # random estimation of log Bayes Factor
 HC = crimeClust_hier(crimedata,varlist,estimateBF)
 plot_hcc(HC,yticks=-2:2)

 # See vignette: "Crime Series Identification and Clustering" for more examples.
}
\references{
Porter, M. D. (2014). A Statistical Approach to Crime Linkage.
   \emph{arXiv preprint arXiv:1410.2285.}.
 \url{http://arxiv.org/abs/1410.2285}
}
\seealso{
\code{\link{clusterPath}, \link{plot_hcc}}
}

