% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/naivebayes.R
\name{getBF}
\alias{getBF}
\title{Estimates the bayes factor for continous and categorical predictors.}
\usage{
getBF(x, y, weights, breaks = NULL, df = 5)
}
\arguments{
\item{x}{predictor vector (continuous or categorical/factors)}

\item{y}{binary vector indicating linkage (1 = linked, 0 = unlinked) or
  logical vector (TRUE = linked, FALSE = unlinked)}

\item{weights}{a vector of observation weights or the column name in
  \code{data} that corresponds to the weights.}

\item{breaks}{set of break point for continuous predictors or NULL for
  categorical or discrete}

\item{df}{the effective degrees of freedom for the cetegorical density
  estimates}
}
\value{
data.frame containing the levels/categories with estimated Bayes factor
}
\description{
This adds pseudo counts to each bin count to give df effective
   degrees of freedom. Must have all possible factor levels and must be of
   factor class.
}
\details{
Continous predictors are first binned, then estimates shrunk towards zero.
}
\note{
Give linked and unlinked a different prior according to sample size
}
\examples{
# See vignette: "Statistical Methods for Crime Series Linkage" for usage.
}

