% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_schedule.R
\name{sch_gantt_matrix}
\alias{sch_gantt_matrix}
\title{Gantt Matrix}
\usage{
sch_gantt_matrix(sch)
}
\arguments{
\item{sch}{A schedule object.}
}
\value{
A matrix where \code{1} indicates that an activity is in execution
and \code{0}, the activity is not executing.
}
\description{
Create a matrix that represents a Gantt chart,
a matrix where "1" indicates that an activity is planned to be
in execution.
\strong{Atention:} the schedule must be planned with the function \code{sch_plan()}.
}
\details{
In this matrix, the rows represent activities,
whereas the columns represents the activity execution period.
So, the number of columns is equal to project duration. The cells is
an integer value that indicates the activity is in execution or not.
}
\examples{
sch <- sch_new() \%>\%
  sch_add_activities(
    id        = c( 1L,  2L,  3L,  4L),
    name      = c("A", "B", "C", "D"),
    duration  = c( 2L,  3L,  1L, 2L )
  ) \%>\%
  sch_add_relations(
    from = c(1L, 2L, 4L, 4L),
    to   = c(3L, 3L, 1L, 2L)
  ) \%>\%
  sch_plan()

sch_duration(sch)
gantt <- sch_gantt_matrix(sch)
gantt

# What is the effort by time period?
colSums(gantt) # 1 1 2 2 1 1

# What is the duration by activities?
rowSums(gantt) # 2 3 1 2

# what is the S curve
cumsum(colSums(gantt))
plot(cumsum(colSums(gantt)), type="l", lwd=3)

}
\seealso{
\code{\link[=sch_add_activities]{sch_add_activities()}}, \code{\link[=sch_activities]{sch_activities()}}, \code{\link[=sch_add_relations]{sch_add_relations()}},
\code{\link[=sch_add_relation]{sch_add_relation()}}, \code{\link[=sch_relations]{sch_relations()}}, \code{\link[=sch_plan]{sch_plan()}},
\code{\link[=sch_xy_gantt_matrix]{sch_xy_gantt_matrix()}}.
}
