\name{weightnorm}
\alias{weightnorm}
\title{Normalize by sample weight}
\usage{
  weightnorm(object, weight = "weight", lg = FALSE)
}
\arguments{
  \item{object}{an \code{ExpressionSet}}

  \item{weight}{a string naming the pheno data column with
  the weight or a numeric vector with one weight value per
  sample.}

  \item{lg}{is the assay data already on the log-scale or
  not. If lg, the weight value is also log-transformed and
  subtraction is used instead of division.}
}
\value{
  the normalized expression set
}
\description{
  Normalize samples by their weight (as in grams fresh
  weight)
}
\details{
  Normalize each sample by dividing by the loaded sample
  weight. The weight argument is takes from the pheno data
  (or given as numerical vector with one value per sample).
  Missing values are not tolerated.
}
\examples{
data(mix)
w <- runif(ncol(mix),1, 1.3)
weightnorm(mix, w)
}
\author{
  Henning Redestig
}

