% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_x}
\alias{read_x}
\title{Read unit cell content (atom and coordinates).}
\usage{
read_x(filename)
}
\arguments{
\item{filename}{A character string. Existing file that includes all structural
information. The file name in general has the form "[prefix]_x.dat".}
}
\value{
A named list with the following elements:
 \itemize{
   \item{a.    Real numeric. Unit cell length in angstroms.}
   \item{SG.   SG 2-letters character string. There are only two symmetries
               possible when working within 1D crystallography, P1 (no 
               symmetry) and P-1 (inversion through the origin). SG can be 
               either "P1" or "P-1".}
   \item{x0.    Vector of real numerics indicating the expanded atomic
                positions in the unit cell.}
   \item{Z.     Vector of integers indicating the expanded 
                atomic numbers for all atoms in the unit cell.}
   \item{B.    Vector of real numerics indicating the expanded 
               B factors for all atoms in the unit cell.}
   \item{occ.  Vector of real numerics indicating the expanded 
               occupancies for all atoms in the unit cell.}
         }
}
\description{
Read unit cell length, space group, atom coordinates and all other
parameters from a coordinate file.
}
\examples{
datadir <- system.file("extdata",package="crone")
filename <- file.path(datadir,"carbon_dioxide_x.dat")
sdata <- read_x(filename)
print(names(sdata))
print(sdata)

}
