% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umap_wrapper.R
\name{prepare_hap_umap}
\alias{prepare_hap_umap}
\title{UMAP haplotype visualization helper}
\usage{
prepare_hap_umap(
  umap_in,
  hetmiss_as = "allele",
  HapObject,
  epsilon,
  vcf,
  nsamples = 25
)
}
\arguments{
\item{umap_in}{UMAP results produced for a haplotype object at a given epsilon.}

\item{hetmiss_as}{If hetmiss_as = "allele", heterozygous-missing SNPs './N'
are recoded as 'N/N', if hetmiss_as = "miss", the site is recoded as missing.}

\item{HapObject}{Haplotype object created by run_haplotyping().}

\item{epsilon}{Epsilon matching the haplotype object used for umap_in.}

\item{vcf}{Input vcf.}

\item{nsamples}{Number of times to sample each haplotype group, will directly
translate to the number of frames in animation. Should be the same as the
nframes passed to gganimate::animate().}
}
\value{
A large ggplot2 object.
}
\description{
prepare_hap_umap() builds a large composite ggplot2 object ready for faceting
and animation (see vignette) for visualizing SNP alleles (coloured by Marker
Group) possessed by individuals with each haplotype. UMAP
coordinates for each SNP can be generated using umap::umap(), with the LD
matrix generated for run_haplotyping() as input. When fully rendered and
faceted, the resultant GIF intuitively visualizes the shared loci within each
Marker Group that are constant within each haplotype combination.
}
