% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encodefrom.R
\name{encodefrom}
\alias{encodefrom}
\alias{encodefrom_}
\title{Encode data frame column using external crosswalk file.}
\usage{
encodefrom(
  .data,
  var,
  cw_file,
  raw,
  clean,
  label,
  delimiter = NULL,
  sheet = NULL,
  case_ignore = TRUE,
  ignore_tibble = FALSE
)

encodefrom_(
  .data,
  var,
  cw_file,
  raw,
  clean,
  label,
  delimiter = NULL,
  sheet = NULL,
  case_ignore = TRUE,
  ignore_tibble = FALSE
)
}
\arguments{
\item{.data}{Data frame or tbl_df}

\item{var}{Column name of vector to be encoded}

\item{cw_file}{Either data frame object or string with path to
external crosswalk file, including path, which has columns
representing \code{raw} (current) vector values, \code{clean}
(new) vector values, and \code{label}s for values. Values in
\code{raw} and \code{clean} columns must be unique (1:1 match)
or an error will be thrown. Acceptable file types include:
delimited (.csv, .tsv, or other), R (.rda, .rdata, .rds), or
Stata (.dta).}

\item{raw}{Name of column in \code{cw_file} that contains values in
current vector.}

\item{clean}{Name of column in \code{cw_file} that contains new
values for vector.}

\item{label}{Name of column in \code{cw_file} with labels for new
values.}

\item{delimiter}{String delimiter used to parse
\code{cw_file}. Only necessary if using a delimited file that
isn't a comma-separated or tab-separated file (guessed by
function based on file ending).}

\item{sheet}{Specify sheet if \code{cw_file} is an Excel file and
required sheet isn't the first one.}

\item{case_ignore}{Ignore case when matching current (\code{raw})
vector name with new (\code{clean}) column name.}

\item{ignore_tibble}{Ignore \code{.data} status as tbl_df and
return vector as a factor rather than labelled vector.}
}
\value{
Vector that is either a factor or labelled, depending on
    data input and options
}
\description{
Encode data frame column using external crosswalk file.
}
\section{Functions}{
\itemize{
\item \code{encodefrom_}: Standard evaluation version of
\code{\link{encodefrom}} (\code{var}, \code{raw}, \code{clean},
and \code{label} must be strings when using this version)
}}

\examples{
df <- data.frame(state = c('Kentucky','Tennessee','Virginia'),
                 stfips = c(21,47,51),
                 cenregnm = c('South','South','South'))

df_tbl <- tibble::as_tibble(df)

cw <- get(data(stcrosswalk))

df$state2 <- encodefrom(df, state, cw, stname, stfips, stabbr)
df_tbl$state2 <- encodefrom(df_tbl, state, cw, stname, stfips, stabbr)
df_tbl$state3 <- encodefrom(df_tbl, state, cw, stname, stfips, stabbr,
                            ignore_tibble = TRUE)

haven::as_factor(df_tbl)
haven::zap_labels(df_tbl)
}
