% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification_model.R
\name{classification_model}
\alias{classification_model}
\alias{classification_model.boosting}
\alias{classification_model.default}
\alias{classification_model.rpart}
\title{Generic function for creating a classification model}
\usage{
classification_model(method, test, x, y, training_data, ...)

\method{classification_model}{default}(method, test, x, y, training_data, ...)

\method{classification_model}{rpart}(method, test, x, y, training_data, ...)

\method{classification_model}{boosting}(method, test, x, y, training_data, ...)
}
\arguments{
\item{method}{The method for classification.}

\item{test}{The test being conducted}

\item{x}{The independent variables.}

\item{y}{The dependent (class) variable. Should be a factor for most algorithms}

\item{training_data}{The complete data set for training}

\item{...}{Extra arguments to pass to the classification algorithm}
}
\value{
The produced model
}
\description{
Generic function for creating a classification model
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default function for creating a classification model

\code{\link[base]{get}} s the method and calls it using \code{x}, \code{y}, and \code{data}

\item \code{rpart}: Rpart specific function for creating a classification model

RPart requires a formula for classification, which is not provided by the default function

\item \code{boosting}: Create a classification model using Freund & Schapire's adaboost.M1
}}

