% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{newFilter}
\alias{newFilter}
\title{Create a new filter}
\usage{
newFilter(name, expression, catalog = NULL, ...)
}
\arguments{
\item{name}{character name for the filter}

\item{expression}{CrunchLogicalExpr with which to make a filter entity}

\item{catalog}{FilterCatalog in which to create the new filter. May also
provide a dataset entity. If omitted, the function will attempt to infer the
dataset (and thus its FilterCatalog) from the contents of \code{expression}.}

\item{...}{Additional filter attributes to set. Options include \code{is_public}.}
}
\value{
A \code{CrunchFilter} object.
}
\description{
This function creates a new filter. You can achieve the same results by
assigning into a dataset's filters catalog, but this may be a more natural
way to think of the action, particularly when you want to do something with
the filter entity after you create it.
}
