% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teams.R
\docType{methods}
\name{teams}
\alias{members}
\alias{members,CrunchTeam-method}
\alias{members<-}
\alias{members<-,CrunchTeam,MemberCatalog-method}
\alias{members<-,CrunchTeam,character-method}
\alias{teams}
\title{Teams}
\usage{
\S4method{members}{CrunchTeam}(x)

\S4method{members}{CrunchTeam,MemberCatalog}(x) <- value

\S4method{members}{CrunchTeam,character}(x) <- value
}
\arguments{
\item{x}{a \code{CrunchTeam}}

\item{value}{for \code{members<-}, a character vector of emails or URLs of
users to add to the team.}
}
\value{
\code{members} returns a
\code{MemberCatalog}, which has references to the users that are members
of the team. \code{members<-} returns \code{x} with the given users added
to the members catalog.
}
\description{
Teams contain users and datasets. You can share a dataset with a group of
users by sharing the dataset with a team. You can also share a bunch of
datasets with a user all at once by adding them to a team that has those
datasets.
}
\details{
These methods allow you to work with teams. Find your teams with the
\code{\link{getTeams}} function, which returns your \code{TeamCatalog}.
Extract an individual team by name. Create a team by assigning in with a new
name, with the assignment value a list, either empty (to just create a team
with that name), or with a "members" element, containing emails or URLs of
users to add to the team. Users can be added later with the \code{members<-}
method.
}
\seealso{
\link{getTeams}
}

