% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_S3.R
\name{calculate_cell_volume.rec_unit_cell}
\alias{calculate_cell_volume.rec_unit_cell}
\title{Volume of a reciprocal unit cell (in angstroms^(-3))}
\usage{
\method{calculate_cell_volume}{rec_unit_cell}(x, ...)
}
\arguments{
\item{x}{An object of class "rec_unit_cell".}

\item{...}{Additional arguments passed to the calculate_cell_volume methods}
}
\value{
A positive numeric, the volume in reciprocal cubic angstroms of the
 reciprocal unit cell corresponding to the input.
}
\description{
Method of the S3 generic class "calculate_cell_volume", to calculate the
volume, in reciprocal cubic angstroms, of the reciprocal unit cell corresponding
to the input object of class "rec_unit_cell".
}
\examples{
# Create a monoclinic cell and the corresponding reciprocal
bt <- bravais("mP")
uc <- create_unit_cell(bt)
ruc <- create_rec_unit_cell(uc)

# Calculate reciprocall cell volume
calculate_cell_volume(ruc)

}
