% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validations.R
\name{check_validity}
\alias{check_validity}
\title{Validity and compatibility of cry objects}
\usage{
check_validity(x, y = NULL, message = FALSE)
}
\arguments{
\item{x}{A first object of one of the new cry classes.}

\item{y}{A second  object of one of the new cry classes.}

\item{message}{A logical variable. If TRUE, the function
prints a message on the errors, if any
(default is FALSE, i.e. no message printed).}
}
\value{
ans A logical value. ans = TRUE means that either the parameters of the single
 object (if only one input is provided) are valid parameters, or that the two objects are
 compatible with each other.
}
\description{
Compatibility of cry objects The objects that can be created in cry are subject to issues of
compatibility of the parameters forming them. For example, the unit cell of a cubic system
cannot have the a, b, c sides different from each other. The present function returns TRUE if
all parts composing the object are compatible with each other. Otherwise it returns FALSE and
one or more warnings with details.
}
\details{
The available checks for individual objects are:
\itemize{
  \item \strong{angle} (unit cell angle)
  \item \strong{bravais} (Bravais system)
  \item \strong{unit_cell} (unit cell)
  \item \strong{rec_unit_cell} (reciprocal unit cell)
  \item \strong{cryst_symm} (crystallographic symmetry)
  \item \strong{merged_reflections} (scaled and merged data)
}
The available checks for couple of objects are:
\itemize{
  \item \strong{bravais} and \strong{unit_cell}
  \item \strong{unit_cell} and \strong{cryst_symm}
}
}
\examples{
# Create a cubic cell with side 50
uc <- create_unit_cell(50)

# Create an object of class "cryst_symm"
crsym <- cryst_symm("P m -3")

# Are they compatible with each other?
check_validity(uc,crsym,TRUE)

}
