% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetry.R
\name{find_symm_setting}
\alias{find_symm_setting}
\title{Find specific space group setting}
\usage{
find_symm_setting(SG)
}
\arguments{
\item{SG}{A character string indicating the extended
Hermann-Mauguin symbol for the space group.}
}
\value{
set An integer equal to the specific setting
            corresponding to the given xHM symbol.
}
\description{
Although a space group is uniquely defined, i.e. the symmetry
operations defining it are uniquely given, the choice of
vectors that defines a unit cell for that symmetry is not
unique. The different choices are known as settings. Most
space groups have only one setting, but it is possible to find
space groups with several settings. For example, "C 1 2/c 1"
has 18 settings. The xHM symbol for setting 1 is
"C 1 2/c 1", the symbol for setting 2 is "A 1 2/n 1", etc.
}
\examples{
# P2 (group number 4) has three settings
nsets <- find_symm_setting("P 1 2 1")
print(nsets)

}
